unit Unit1;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  extctrls,stdctrls, ComCtrls, Menus, Buttons;
const
  n=15;
type
  TForm1 = class(TForm)
    btnStart: TButton;
    Timer1: TTimer;
    StatusBar1: TStatusBar;
    MainMenu1: TMainMenu;
    mnuFajl: TMenuItem;
    mnuKilepes: TMenuItem;
    procedure IdozitoProc(Sender: TObject);
    procedure FutoProc(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure mnuKilepesClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
     futok    : array [1..n] of TButton;
     idozitok : array [1..n] of TTimer;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}
var
 lathatok: integer;
 eltelt: longint;
 dX: array [1..n] of integer;
 dY: array [1..n] of integer;

procedure TForm1.IdozitoProc(Sender: TObject);
var melyik: integer;
begin
  melyik:=(sender as TTimer).tag;
  with futok[melyik] do
  begin
    left:=left+dX[melyik];
    top:=top+dY[melyik];
    if (left<6) or (left>(Form1.ClientWidth-width-6))
      then dX[melyik]:=-dX[melyik];
    if (top<6) or (top>(Form1.ClientHeight-StatusBar1.Height-25))
      then dY[melyik]:=-dY[melyik];
  end;
end;

procedure TForm1.FutoProc(Sender: TObject);
begin
  idozitok[(sender as TButton).tag].enabled:=false;
  futok[(sender as TButton).tag].visible:=false;

  lathatok:=lathatok-1;
  StatusBar1.Panels.Items[1].Text:='Maradt mg: '+IntToStr(lathatok);

  if lathatok=0 then
   with StatusBar1.Panels do
    begin
     Timer1.enabled:=false;
     Application.MessageBox('Jtk vge!', PChar(Items[2].Text), MB_OK);
     Items[1].Text:='';
     Items[2].Text:='';
     btnStart.visible:=true;
    end;
end;

procedure TForm1.btnStartClick(Sender: TObject);
var i:integer;
begin
 eltelt:=0;
 lathatok:=n;

 with StatusBar1.Panels do
  begin
   Items[0].Text:='sszesen: '+IntToStr(lathatok);
   Items[1].Text:='Maradt mg: '+IntToStr(lathatok);
   Items[2].Text:='Eltelt: 0 mp';
  end;

 btnStart.visible:=false;

 randomize;

 for i:=1 to n do
  begin
    dX[i]:=-3+random(6);
    dY[i]:=-3+random(6);
    if dX[i]=0 then dX[i]:=1;
    if dY[i]=0 then dY[i]:=1;

    futok[i] :=TButton.Create(self);

    with futok[i] do
     begin
      left:=random(Form1.ClientWidth-100)+40;
      top:=i*10;
      width:=35;
      height:=20;
      parent:=self;
      cursor:=crHandPoint;
      visible:=true;
      tag:=i;
      onclick:=FutoProc;
     end;
  end;

 for i:=1 to n do
  begin
   idozitok[i]:=TTimer.Create(self);
   with idozitok[i] do
    begin
     Interval:=50;
     enabled:=true;
     tag:=i;
     ontimer:=IdozitoProc;
    end;
  end;

  Timer1.enabled:=true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  eltelt:=eltelt+Timer1.Interval;
  StatusBar1.Panels.Items[2].Text:='Eltelt: '+IntToStr(eltelt div 1000)+' mp';
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  randomize;
end;

procedure TForm1.mnuKilepesClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
 var i: integer;
begin
 for i:=1 to n do
  begin
   futok[i].Free;
   idozitok[i].Free;
  end;
  Application.Terminate;
end;

end.
